<?php

namespace wcf\system\user\authentication\password\algorithm;

use wcf\system\user\authentication\password\IPasswordAlgorithm;

/**
 * Always indicates that the password is invalid.
 *
 * @author  Tim Duesterhus
 * @copyright   2001-2020 WoltLab GmbH
 * @license GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package WoltLabSuite\Core\System\User\Authentication\Password\Algorithm
 * @since   5.4
 */
final class Invalid implements IPasswordAlgorithm
{
    /**
     * @inheritDoc
     */
    public function verify(string $password, string $hash): bool
    {
        return false;
    }

    /**
     * @inheritDoc
     */
    public function hash(string $password): string
    {
        return '';
    }

    /**
     * @inheritDoc
     */
    public function needsRehash(string $hash): bool
    {
        return false;
    }
}
